<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("vendors.dashboard"),
        ]
    ], 'active' => __("Profile")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mb-20-none">
        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card mt-10">

                <div class="dashboard-header-wrapper d-flex justify-content-between">
                    <h4 class="title"><?php echo e(@$page_title); ?></h4>
                    <a href="javascript:void(0)" class="btn--danger btn delete-btn"><?php echo e(__("Delete Account")); ?></a>
                </div>
                <div class="card-body profile-body-wrapper">
                    <form class="card-form" method="POST" action="<?php echo e(setRoute('vendors.profile.update')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field("PUT"); ?>
                        <div class="profile-settings-wrapper">
                            <div class="preview-thumb profile-wallpaper">
                                <div class="avatar-preview">
                                    <div class="profilePicPreview bg_img" data-background="<?php echo e(asset('public/frontend/images/baner/vendor-banner.webp')); ?>"></div>
                                </div>
                            </div>
                            <div class="profile-thumb-content">
                                <div class="preview-thumb profile-thumb">
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview bg_img" data-background="<?php echo e(auth()->user()->userImage); ?>"></div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type='file' class="profilePicUpload" name="image" id="profilePicUpload2" accept=".png, .jpg, .jpeg, .webp, .svg" />
                                        <label for="profilePicUpload2"><i class="las la-upload"></i></label>
                                    </div>
                                </div>
                                <div class="profile-content">
                                    <h6 class="username"><?php echo e(auth()->user()->username); ?></h6>
                                    <ul class="user-info-list mt-md-2">
                                        <li><i class="las la-envelope"></i><?php echo e(auth()->user()->email); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="profile-form-area">
                            <div class="row">
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("First Name")."*",
                                        'name'          => "firstname",
                                        'placeholder'   => __("First Name"),
                                        'value'         => old('firstname',auth()->user()->firstname)
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("Last Name")."*",
                                        'name'          => "lastname",
                                        'placeholder'   => __("Last Name"),
                                        'value'         => old('lastname',auth()->user()->lastname)
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                </div>
                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Country")); ?></label>
                                    <select name="country" class="form--control select2-auto-tokenize country-select" data-placeholder="Select Country" data-old="<?php echo e(old('country',auth()->user()->address->country ?? "")); ?>">
                                    </select>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <label><?php echo e(__("Phone")); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-text phone-code">+<?php echo e(auth()->user()->mobile_code); ?></div>
                                        <input class="phone-code" type="hidden" name="phone_code" value="<?php echo e(auth()->user()->mobile_code); ?>" />
                                        <input type="text" class="form--control" placeholder="<?php echo e(__("Enter Phone")); ?>" name="phone" value="<?php echo e(old('phone',auth()->user()->mobile)); ?>">
                                    </div>
                                    <?php $__errorArgs = ["phone"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback d-block" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("Address"),
                                        'name'          => "address",
                                        'placeholder'   => __("Enter Address"),
                                        'value'         => old('address',auth()->user()->address->address ?? "")
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => "City",
                                        'name'          => "city",
                                        'placeholder'   => __("Select City"),
                                        'value'         => old('city',auth()->user()->address->city ?? "")
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("State"),
                                        'name'          => "state",
                                        'placeholder'   => __("Select State"),
                                        'value'         => old('state',auth()->user()->address->state ?? "")
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <div class="col-xl-6 col-lg-6 form-group">
                                    <?php echo $__env->make('admin.components.form.input',[
                                        'label'         => __("Zip Code"),
                                        'name'          => "zip_code",
                                        'placeholder'   => __("Enter Zip"),
                                        'value'         => old('zip_code',auth()->user()->address->zip ?? "")
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                            </div>
                            <div class="col-xl-12 col-lg-12">
                                <button type="submit" class="btn--base w-100"><?php echo e(__("Update")); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-xl-6 col-lg-6 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__("Change Password")); ?></h4>
                </div>
                <div class="card-body">
                    <form class="card-form" action="<?php echo e(setRoute('vendors.profile.password.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field("PUT"); ?>
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 form-group show_hide_password">
                                <label for="current_password"><?php echo e(__("Current Password")); ?>*</label>
                                <input type="password" name="current_password" id="current_password" class="form--control" placeholder="<?php echo e(__("Enter Password")); ?>">
                                <a href="javascript:void(0);" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                            </div>

                            <div class="col-xl-12 col-lg-12 form-group show_hide_password">
                                <label for="password"><?php echo e(__("New Password")); ?>*</label>
                                <input type="password" name="password" id="password" class="form--control" placeholder="<?php echo e(__("Enter Password")); ?>">
                                <a href="javascript:void(0);" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                            </div>

                            <div class="col-xl-12 col-lg-12 form-group show_hide_password">
                                <label for="password_confirmation"><?php echo e(__("Confirm Password")); ?>*</label>
                                <input type="password" name="password_confirmation" id="password_confirmation" class="form--control" placeholder="<?php echo e(__("Enter Password")); ?>">
                                <a href="javascript:void(0);" class="show-pass profile"><i class="fa fa-eye-slash" aria-hidden="true"></i></a>
                            </div>
                        </div>

                        <div class="col-xl-12 col-lg-12">
                            <button type="submit" class="btn--base w-100"><?php echo e(__("Change")); ?></button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        getAllCountries("<?php echo e(setRoute('global.countries')); ?>");
        $(document).ready(function(){
            $("select[name=country]").change(function(){
                var phoneCode = $("select[name=country] :selected").attr("data-mobile-code");
                placePhoneCode(phoneCode);
            });
            countrySelect(".country-select",$(".country-select").siblings(".select2"));

        });

        $(".delete-btn").click(function(){
            var actionRoute =  "<?php echo e(setRoute('vendors.delete.account')); ?>";
            var target      = 1;
            var btnText = "Delete Account";
            var projectName = "<?php echo e(@$basic_settings->site_name); ?>";
            var name = $(this).data('name');
            var message     = `Are you sure to delete <strong>your account</strong>?<br>If you do not think you will use “<strong>${projectName}</strong>”  again and like your account deleted, we can take card of this for you. Keep in mind you will not be able to reactivate your account or retrieve any of the content or information you have added. If you would still like your account deleted, click “Delete Account”.?`;
            openAlertModal(actionRoute,target,message,btnText,"DELETE");
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/profile/index.blade.php ENDPATH**/ ?>