<?php
    $app_local      = get_default_language_code();
    $default        = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug           = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FOOTER_SECTION);
    $footer         = App\Models\Admin\SiteSections::getData($slug)->first();

    $usefull_links  = App\Models\Admin\UsefulLink::where('status',true)->get();
?>
 <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        Start Footer
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
 <footer class="footer-section">
    <div class="container mx-auto">
       <div class="footer-content pt-80">
               <div class="row">
                   <div class="col-xl-4 col-lg-4 mb-50">
                       <div class="footer-widget">
                           <div class="footer-text">
                                 <img src="<?php echo e(get_logo($basic_settings)); ?>" alt="logo">
                                 <p><?php echo e($footer->value->contact->language->$app_local->contact_desc ?? $footer->value->contact->language->$default->contact_desc ?? ''); ?></p>
                           </div>
                           <div class="footer-social-icon">
                            <span><?php echo e(__("Follow us")); ?>:</span>
                            <?php $__currentLoopData = $footer->value->contact->social_links ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <a href="<?php echo e($item->link ?? ''); ?>"><i class="<?php echo e($item->icon ?? ''); ?>"></i></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                       </div>
                   </div>
                   <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                       <div class="footer-widget">
                           <div class="footer-widget-heading">
                            <h3 class="title"><?php echo e(__("Useful Links")); ?></h3>
                           </div>
                           <ul>
                            <?php if(isset($usefull_links)): ?>
                            <?php $__currentLoopData = $usefull_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(setRoute('frontend.link',$item->slug)); ?>"><?php echo e($item->title->language->$app_local->title ?? $item->title->language->$default->title ?? ""); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                           </ul>
                       </div>
                   </div>
                   <div class="col-xl-4 col-lg-4 col-md-6 mb-50">
                       <div class="footer-widget">
                           <div class="footer-widget-heading">
                               <h3><?php echo e(__('Subscribe')); ?></h3>
                           </div>
                           <div class="footer-text mb-25">
                               <p><?php echo e(__('Don’t miss to subscribe to our new feeds, kindly fill the form below')); ?></p>
                           </div>
                           <div class="subscribe-form">
                            <form action="<?php echo e(setRoute('frontend.subscribe')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="email" class="form--control" placeholder=<?php echo e(__('Email Address')); ?> name="email">
                                <button type="submit">
                                    <i class="fab fa-telegram-plane"></i>
                                </button>
                            </form>

                           </div>
                       </div>
                   </div>
               </div>
       </div>
   </div>
   <div class="copyright-area">
       <div class="container">
           <div class="row">
               <div class="col-12 text-center text-lg-left">
                   <div class="copyright-text">
                          <p><?php echo e(__("Copyright")); ?> &copy; <?php echo e(date('Y')); ?>, <?php echo e(__("All Right Reserved")); ?> <a href="#"><?php echo e($basic_settings->site_name); ?></a></p>
                    </div>
               </div>
            </div>
       </div>
   </div>
</footer>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       End Footer
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->


<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/partials/footer.blade.php ENDPATH**/ ?>