<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-logo">
            <a href="<?php echo e(setRoute('admin.dashboard')); ?>" class="sidebar-main-logo">
                <img src="<?php echo e(get_logo($basic_settings)); ?>" data-white_img="<?php echo e(get_logo($basic_settings, 'white')); ?>"
                    data-dark_img="<?php echo e(get_logo($basic_settings, 'dark')); ?>" alt="logo">
            </a>
            <button class="sidebar-menu-bar">
                <i class="fas fa-exchange-alt"></i>
            </button>
        </div>
        <div class="sidebar-user-area">
            <div class="sidebar-user-thumb">
                <a href="<?php echo e(setRoute('admin.profile.index')); ?>"><img
                        src="<?php echo e(get_image(Auth::user()->image, 'admin-profile', 'profile')); ?>" alt="user"></a>
            </div>
            <div class="sidebar-user-content">
                <h6 class="title"><?php echo e(Auth::user()->fullname); ?></h6>
                <span class="sub-title"><?php echo e(Auth::user()->getRolesString()); ?></span>
            </div>
        </div>
        <?php
            $current_route = Route::currentRouteName();
        ?>
        <div class="sidebar-menu-wrapper">
            <ul class="sidebar-menu">

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.dashboard',
                    'title' => __('Dashboard'),
                    'icon' => 'menu-icon las la-rocket',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Default'),
                    'group_links' => [
                        [
                            'title' => __('Setup Currency'),
                            'route' => 'admin.currency.index',
                            'icon' => 'menu-icon las la-coins',
                        ],
                        [
                            'title' => __('Fees & Charges'),
                            'route' => 'admin.trx.settings.index',
                            'icon' => 'menu-icon las la-wallet',
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Salon'),
                    'group_links' => [
                        [
                            'title' => __('Setup Area'),
                            'route' => 'admin.area.index',
                            'icon' => 'menu-icon las la-long-arrow-alt-right',
                        ],
                        [
                            'title' => __('Salon List'),
                            'route' => 'admin.parlour.list.index',
                            'icon' => 'menu-icon las la-coins',
                        ],
                        [
                            'title' => __('Salon Request'),
                            'route' => 'admin.parlour.list.parlour.request',
                            'icon' => 'menu-icon las la-coins',
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Logs'),
                    'group_links' => [
                        'dropdown' => [
                            [
                                'title' => __('Booking'),
                                'icon' => 'menu-icon las la-calculator',
                                'links' => [
                                    [
                                        'title' => __('Pending Logs'),
                                        'route' => 'admin.booking.log.pending',
                                    ],
                                    [
                                        'title' => __('Completed Logs'),
                                        'route' => 'admin.booking.log.complete',
                                    ],
                                    [
                                        'title' => __('Canceled Logs'),
                                        'route' => 'admin.booking.log.canceled',
                                    ],
                                    [
                                        'title' => __('All Logs'),
                                        'route' => 'admin.booking.log.index',
                                    ],
                                ],
                            ],
                            [
                                'title' => __('Money Out Logs'),
                                'icon' => 'menu-icon las la-sign-out-alt',
                                'links' => [
                                    [
                                        'title' => __('Pending Logs'),
                                        'route' => 'admin.money.out.pending',
                                    ],
                                    [
                                        'title' => __('Completed Logs'),
                                        'route' => 'admin.money.out.complete',
                                    ],
                                    [
                                        'title' => __('Canceled Logs'),
                                        'route' => 'admin.money.out.canceled',
                                    ],
                                    [
                                        'title' => __('All Logs'),
                                        'route' => 'admin.money.out.index',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Interface Panel'),
                    'group_links' => [
                        'dropdown' => [
                            [
                                'title' => __('User Care'),
                                'icon' => 'menu-icon las la-user-edit',
                                'links' => [
                                    [
                                        'title' => __('Active Users'),
                                        'route' => 'admin.users.active',
                                    ],
                                    [
                                        'title' => __('Email Unverified'),
                                        'route' => 'admin.users.email.unverified',
                                    ],
                                    [
                                        'title' => __('All Users'),
                                        'route' => 'admin.users.index',
                                    ],
                                    [
                                        'title' => __('Email To Users'),
                                        'route' => 'admin.users.email.users',
                                    ],
                                    [
                                        'title' => __('Banned Users'),
                                        'route' => 'admin.users.banned',
                                    ],
                                    [
                                        'title' => __('Add User'),
                                        'route' => 'admin.users.create',
                                    ],
                                ],
                            ],
                            [
                                'title' => __('Vendor Care'),
                                'icon' => 'menu-icon las la-user-edit',
                                'links' => [
                                    [
                                        'title' => __('Active Vendors'),
                                        'route' => 'admin.vendors.active',
                                    ],
                                    [
                                        'title' => __('Email Unverified'),
                                        'route' => 'admin.vendors.email.unverified',
                                    ],
                                    [
                                        'title' => __('KYC Unverified'),
                                        'route' => 'admin.vendors.kyc.unverified',
                                    ],
                                    [
                                        'title' => __('All Vendors'),
                                        'route' => 'admin.vendors.index',
                                    ],
                                    [
                                        'title' => __('Email To Vendors'),
                                        'route' => 'admin.vendors.email.vendors',
                                    ],
                                    [
                                        'title' => __('Banned Vendors'),
                                        'route' => 'admin.vendors.banned',
                                    ],
                                      [
                                        'title' => __('Add Vendor'),
                                        'route' => 'admin.vendors.create',
                                    ],
                                ],
                            ],
                            [
                                'title' => __('Admin Care'),
                                'icon' => 'menu-icon las la-user-shield',
                                'links' => [
                                    [
                                        'title' => __('All Admin'),
                                        'route' => 'admin.admins.index',
                                    ],
                                    [
                                        'title' => __('Admin Role'),
                                        'route' => 'admin.admins.role.index',
                                    ],
                                    [
                                        'title' => __('Role Permission'),
                                        'route' => 'admin.admins.role.permission.index',
                                    ],
                                    [
                                        'title' => __('Email To Admin'),
                                        'route' => 'admin.admins.email.admins',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Settings'),
                    'group_links' => [
                        'dropdown' => [
                            [
                                'title' => __('Web Settings'),
                                'icon' => 'menu-icon lab la-safari',
                                'links' => [
                                    [
                                        'title' => __('Basic Settings'),
                                        'route' => 'admin.web.settings.basic.settings',
                                    ],
                                    [
                                        'title' => __('Image Assets'),
                                        'route' => 'admin.web.settings.image.assets',
                                    ],
                                    [
                                        'title' => __('Setup SEO'),
                                        'route' => 'admin.web.settings.setup.seo',
                                    ],
                                ],
                            ],
                            [
                                'title' => __('App Settings'),
                                'icon' => 'menu-icon las la-mobile',
                                'links' => [
                                    [
                                        'title' => __('Splash Screen'),
                                        'route' => 'admin.app.settings.splash.screen',
                                    ],
                                    [
                                        'title' => __('Onboard Screen'),
                                        'route' => 'admin.app.settings.onboard.screens',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.languages.index',
                    'title' => __('Languages'),
                    'icon' => 'menu-icon las la-language',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.system.maintenance.index',
                    'title' => __('System Maintenance'),
                    'icon' => 'menu-icon las la-tools',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Verification Center'),
                    'group_links' => [
                        'dropdown' => [
                            [
                                'title' => __('Setup Email'),
                                'icon' => 'menu-icon las la-envelope-open-text',
                                'links' => [
                                    [
                                        'title' => __('Email Method'),
                                        'route' => 'admin.setup.email.config',
                                    ],
                                ],
                            ],
                        ],
                        [
                            'title' => __('Subscribers'),
                            'route' => 'admin.subscriber.index',
                            'icon' => 'menu-icon las la-bell',
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php if(admin_permission_by_name('admin.setup.sections.section')): ?>
                    <li class="sidebar-menu-header"><?php echo e(__('Setup Web Content')); ?></li>
                    <?php
                        $current_url = URL::current();

                        $setup_section_childs = [
                            setRoute('admin.setup.sections.section', 'banner'),
                            setRoute('admin.setup.sections.section', 'features'),
                            setRoute('admin.setup.sections.section', 'how-it-work'),
                            setRoute('admin.setup.sections.section', 'why-choice-us'),
                            setRoute('admin.setup.sections.section', 'statistics'),
                            setRoute('admin.setup.sections.section', 'download-app'),
                            setRoute('admin.setup.sections.section', 'about-us'),
                            setRoute('admin.setup.sections.section', 'faq'),
                            setRoute('admin.setup.sections.section', 'services'),
                            setRoute('admin.setup.sections.section', 'contact'),
                            setRoute('admin.setup.sections.section', 'blog'),
                            setRoute('admin.setup.sections.section', 'clients-feedback'),
                            setRoute('admin.setup.sections.section', 'contact-us'),
                            setRoute('admin.setup.sections.section', 'footer'),
                            setRoute('admin.setup.sections.section', 'auth'),
                        ];

                        $vendor_section_childs = [
                            setRoute('admin.setup.sections.section', 'vendor-banner'),
                            setRoute('admin.setup.sections.section', 'vendor-features'),
                            setRoute('admin.setup.sections.section', 'vendor-requirements'),
                        ];
                    ?>


                    <li class="sidebar-menu-item sidebar-dropdown <?php if(in_array($current_url, $setup_section_childs)): ?> active <?php endif; ?>">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-terminal"></i>
                            <span class="menu-title"><?php echo e(__('Setup Section')); ?></span>
                        </a>
                        <ul class="sidebar-submenu">
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'banner')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'banner')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Banner Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'features')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'features')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Features Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'how-it-work')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'how-it-work')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('How Its Work Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'why-choice-us')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'why-choice-us')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Choice Us Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'statistics')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'statistics')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Statistics Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'download-app')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'download-app')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Downlaod App section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'about-us')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'about-us')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('About Us Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'faq')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'faq')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('FAQ Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'services')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'services')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Services Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'contact')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'contact')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Contact Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'blog')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'blog')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Blog Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'clients-feedback')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'clients-feedback')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Clients Feedback')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'footer')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'footer')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Footer Section')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'auth')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'auth')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Auth Section')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown <?php if(in_array($current_url, $setup_section_childs)): ?> active <?php endif; ?>">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-store"></i>
                            <span class="menu-title"><?php echo e(__('Vendor Section')); ?></span>
                        </a>
                        <ul class="sidebar-submenu">
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'vendor-banner')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'vendor-banner')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Banner Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'vendor-features')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'vendor-features')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Features Section')); ?></span>
                                </a>

                                <a href="<?php echo e(setRoute('admin.setup.sections.section', 'vendor-requirements')); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.setup.sections.section', 'vendor-requirements')): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Requirements Section')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.setup.pages.index',
                    'title' => __('Setup Pages'),
                    'icon' => 'menu-icon las la-file-alt',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.extensions.index',
                    'title' => __('Extensions'),
                    'icon' => 'menu-icon las la-puzzle-piece',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.useful.links.index',
                    'title' => __('Useful Links'),
                    'icon' => 'menu-icon las la-link',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php if(admin_permission_by_name('admin.payment.gateway.view')): ?>
                    <li class="sidebar-menu-header"><?php echo e(__('Payment Methods')); ?></li>
                    <?php
                        $payment_payment_method_childs = [
                            setRoute('admin.payment.gateway.view', ['payment-method', 'automatic']),
                            setRoute('admin.payment.gateway.view', ['money-out', 'manual']),
                        ];
                    ?>
                    <li class="sidebar-menu-item sidebar-dropdown <?php if(in_array($current_url, $payment_payment_method_childs)): ?> active <?php endif; ?>">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-funnel-dollar"></i>
                            <span class="menu-title"><?php echo e(__('Payment Method')); ?></span>
                        </a>
                        <ul class="sidebar-submenu">
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(setRoute('admin.payment.gateway.view', ['payment-method', 'automatic'])); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.payment.gateway.view', ['payment-method', 'automatic'])): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Automatic')); ?></span>
                                </a>
                                <a href="<?php echo e(setRoute('admin.payment.gateway.view', ['money-out', 'manual'])); ?>"
                                    class="nav-link <?php if($current_url == setRoute('admin.payment.gateway.view', ['add-money', 'manual'])): ?> active <?php endif; ?>">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo e(__('Manual')); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?>

                
                <?php echo $__env->make('admin.components.side-nav.link-group', [
                    'group_title' => __('Notification'),
                    'group_links' => [
                        'dropdown' => [
                            [
                                'title' => __('Push Notification'),
                                'icon' => 'menu-icon las la-bell',
                                'links' => [
                                    [
                                        'title' => __('Setup Notification'),
                                        'route' => 'admin.push.notification.config',
                                    ],
                                    [
                                        'title' => __('Send Notification'),
                                        'route' => 'admin.push.notification.index',
                                    ],
                                ],
                            ],
                        ],
                        [
                            'title' => __('Contact Messages'),
                            'route' => 'admin.contact.messages.index',
                            'icon' => 'menu-icon las la-sms',
                        ],
                    ],
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php
                    $bonus_routes = ['admin.cookie.index', 'admin.server.info.index', 'admin.cache.clear'];
                ?>

                <?php if(admin_permission_by_name_array($bonus_routes)): ?>
                    <li class="sidebar-menu-header"><?php echo e(__('Bonus')); ?></li>
                <?php endif; ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.cookie.index',
                    'title' => __('GDPR Cookie'),
                    'icon' => 'menu-icon las la-cookie-bite',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.server.info.index',
                    'title' => __('Server Info'),
                    'icon' => 'menu-icon las la-sitemap',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.error.logs.index',
                    'title' => __('Error Logs'),
                    'icon' => 'menu-icon las la-bug',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php echo $__env->make('admin.components.side-nav.link', [
                    'route' => 'admin.cache.clear',
                    'title' => __('Clear Cache'),
                    'icon' => 'menu-icon las la-broom',
                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </ul>
        </div>
    </div>
</div>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub-web-v2.0.0\resources\views/admin/partials/side-nav.blade.php ENDPATH**/ ?>