<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Profile'),
                'url' => setRoute('user.profile.index'),
            ],
        ],
        'active' => __('My History'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="appointment-area">
                <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> <?php echo e(__('Booking Details')); ?></h3>
                <div class="salon-thumb">
                    <img src="<?php echo e(get_image($data->parlour->image, 'site-section')); ?>" alt="img">
                </div>
                <div class="about-details">
                    <div class="salon-title">
                        <h3 class="title"><i class="las la-user-alt"></i> <?php echo e(__('Salon Information')); ?></h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Salon Name')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->parlour->name ?? ''); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Contact')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->parlour->contact ?? ''); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Salon Address')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->parlour->address ?? ''); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="salon-title pt-4">
                        <h3 class="title"><i class="las la-street-view"></i> <?php echo e(__('Service Information')); ?></h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Service Name')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e(implode(', ', $data->service) ?? ''); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="shedule-title pt-4">
                        <h3 class="title"><i class="fas fa-history"> </i> <?php echo e(__('Schedule Information')); ?></h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Date')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->date); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Time')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->schedule->from_time ?? ''); ?> - <?php echo e($data->schedule->to_time ?? ''); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Serial Number')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->serial_number ?? ''); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="shedule-title pt-4">
                        <h3 class="title"><i class="las la-comment-dollar"></i> <?php echo e(__('Payment Information')); ?></h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('MTCN Number')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->trx_id ?? ''); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Payment Method')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e($data->payment_method ?? ''); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Total Service Price')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data->price)); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Fees & Charges')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data->total_charge)); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Total Payable Price')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <p><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($data->payable_price)); ?></p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p><?php echo e(__('Status')); ?> :</p>
                            </div>
                            <div class="preview-details">
                                <span class="<?php echo e($data->stringStatus->class); ?>"><?php echo e(__($data->stringStatus->value)); ?></span>
                            </div>
                        </div>
                        <?php if($data->status == global_const()::STATUSSUCCESS && !$data->review): ?>
                            <div class="shedule-title pt-4">
                                <h3 class="title"><i class="las la-star"></i> <?php echo e(__('Add Review')); ?></h3>
                            </div>
                            <div class="list-wrapper">
                                <form action="<?php echo e(setRoute('user.my.booking.review', $data->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Your Rating')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <div class="rating-wrapper">
                                                <input type="radio" id="star5" name="rating" value="5"
                                                    required />
                                                <label for="star5" title="5 stars">☆</label>
                                                <input type="radio" id="star4" name="rating" value="4" />
                                                <label for="star4" title="4 stars">☆</label>
                                                <input type="radio" id="star3" name="rating" value="3" />
                                                <label for="star3" title="3 stars">☆</label>
                                                <input type="radio" id="star2" name="rating" value="2" />
                                                <label for="star2" title="2 stars">☆</label>
                                                <input type="radio" id="star1" name="rating" value="1" />
                                                <label for="star1" title="1 star">☆</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p><?php echo e(__('Your Review')); ?> :</p>
                                        </div>
                                        <div class="preview-details">
                                            <textarea name="comment" class="form-control" rows="3" placeholder="<?php echo e(__('Write your review here...')); ?>"></textarea>
                                        </div>
                                    </div>
                                    <div class="text-end mt-3">
                                        <button type="submit" class="btn--base"><?php echo e(__('Submit Review')); ?></button>
                                    </div>
                                </form>
                            </div>
                        <?php elseif($data->review): ?>
                            <div class="shedule-title pt-4">
                                <h3 class="title"><i class="las la-star"></i> <?php echo e(__('Your Review')); ?></h3>
                            </div>
                            <div class="list-wrapper">
                                <div class="preview-area">
                                    <div class="preview-item">
                                        <p><?php echo e(__('Rating')); ?> :</p>
                                    </div>
                                    <div class="preview-details">
                                        <div class="rating-display">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $data->review): ?>
                                                    <span class="star-filled">★</span>
                                                <?php else: ?>
                                                    <span class="star-empty">☆</span>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-area">
                                    <div class="preview-item">
                                        <p><?php echo e(__('Review')); ?> :</p>
                                    </div>
                                    <div class="preview-details">
                                        <p><?php echo e($data->comment); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/user/sections/my-booking/details.blade.php ENDPATH**/ ?>