<!DOCTYPE html>
<html>

<head>
    <title><?php echo e($page_title); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .details {
            margin-bottom: 15px;
        }

        .detail-label {
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1><?php echo e($page_title); ?></h1>
        <p>Booking Reference: <?php echo e($data->trx_id); ?></p>
    </div>

    <div class="details">
        <h2>Booking Information</h2>
        <table>
            <tr>
                <td class="detail-label">Date:</td>
                <td><?php echo e($data->date); ?></td>
            </tr>
            <tr>
                <td class="detail-label">Serial Number:</td>
                <td><?php echo e($data->serial_number); ?></td>
            </tr>
            <tr>
                <td class="detail-label">Status:</td>
                <td>
                    <span class="<?php echo e($data->stringStatus->class); ?>"><?php echo e(__($data->stringStatus->value)); ?></span>
                </td>
            </tr>
            <tr>
                <td class="detail-label">Payment Method:</td>
                <td><?php echo e($data->payment_method); ?></td>
            </tr>
        </table>
    </div>

    <div class="details">
        <h2>Services</h2>
        <ul>
            <?php $__currentLoopData = $data->service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($service); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>

    <div class="details">
        <h2>Pricing</h2>
        <table>
            <tr>
                <td class="detail-label">Base Price:</td>
                <td><?php echo e(number_format((float) $data->price, 2)); ?> <?php echo e($data->payment_currency ?? 'USD'); ?></td>
            </tr>
            <tr>
                <td class="detail-label">Additional Charges:</td>
                <td><?php echo e(number_format((float) $data->total_charge, 2)); ?> <?php echo e($data->payment_currency ?? 'USD'); ?></td>
            </tr>
            <tr>
                <td class="detail-label">Total Payable:</td>
                <td><?php echo e(number_format((float) $data->payable_price, 2)); ?> <?php echo e($data->payment_currency ?? 'USD'); ?></td>
            </tr>
        </table>
    </div>
</body>

</html>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/user/sections/my-booking/pdf-details.blade.php ENDPATH**/ ?>