<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::LOGIN_SECTION);
    $login = App\Models\Admin\SiteSections::getData($slug)->first();
?>


<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="register-section ptb-80">
        <div class="container">
            <div class="row mb-40-none align-items-center justify-content-center">
                <div class="col-lg-6 col-md-12 mb-40">
                    <div class="register-content">
                        <h2 class="title">
                            <?php echo e($login->value->language->$app_local->title ?? ($login->value->language->$default->title ?? '')); ?>

                        </h2>
                        <p><?php echo e($login->value->language->$app_local->heading ?? ($login->value->language->$default->heading ?? '')); ?>

                        </p>
                    </div>
                </div>
                <div class="col-lg-6 col-md-9 mb-40">
                    <div class="register-form">
                        <div class="login-form">
                            <div class="form-hader d-flex justify-content-between">
                                <div class="login-button" <?php if($basic_settings->user_registration == false): ?> style="width: 100%;" <?php endif; ?>>
                                    <button class="btn login-btn active w-100"><?php echo e(__('Login')); ?></button>
                                </div>
                                <?php if($basic_settings->user_registration): ?>
                                    <div class="register-button">
                                        <button class="btn register-btn"><?php echo e(__('Registration')); ?></button>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <form class="account-form" id="login" method="POST"
                                action="<?php echo e(setRoute('user.login.submit')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="login-information pt-30">
                                    <div class="row mb-10-none">
                                        <div class="col-lg-12 form-group mb-10">
                                            <label><?php echo e(__('Enter Email')); ?></label>
                                            <input type="email" class="form-control form--control" name="credentials"
                                                placeholder="<?php echo e(__('Enter Email')); ?>...">
                                        </div>
                                        <div class="col-lg-12 form-group show_hide_password mb-10">
                                            <label><?php echo e(__('Enter Password')); ?></label>
                                            <input type="password" class="form-control form--control" name="password"
                                                placeholder="<?php echo e(__('Enter Password')); ?>...">
                                            <a href="#0" class="show-pass"><i class="fa fa-eye-slash"
                                                    aria-hidden="true"></i></a>
                                        </div>
                                        <div class="col-lg-12 form-group">
                                            <div class="forgot-item text-end">
                                                <label><a href="<?php echo e(setRoute('user.password.forgot')); ?>"
                                                        class="text--base"><?php echo e(__('Forgot Password?')); ?></a></label>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 form-group text-center">
                                            <button type="submit" class="btn--base w-100"><?php echo e(__('Login Now')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <form id="register" class="d-none" method="POST"
                                action="<?php echo e(setRoute('user.register.submit')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="personal-account pt-30 select-account" data-select-target="1">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 form-group">
                                            <label><?php echo e(__('First Name')); ?></label>
                                            <input type="text" class="form-control form--control" name="firstname"
                                                placeholder="<?php echo e(__('First Name')); ?>">
                                        </div>
                                        <div class="col-lg-6 col-md-6 form-group">
                                            <label><?php echo e(__('Last Name')); ?></label>
                                            <input type="text" class="form-control form--control" name="lastname"
                                                placeholder="<?php echo e(__('Last Name')); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group">
                                            <label><?php echo e(__('Email')); ?></label>
                                            <input type="email" class="form-control form--control" name="email"
                                                placeholder="<?php echo e(__('Email')); ?>">
                                        </div>
                                        <div class="col-lg-12 form-group show_hide_password-2">
                                            <label><?php echo e(__('Password')); ?></label>
                                            <input type="password" class="form-control form--control" name="password"
                                                placeholder="<?php echo e(__('Password')); ?>">
                                            <a href="#0" class="show-pass"><i class="fa fa-eye-slash"
                                                    aria-hidden="true"></i></a>
                                        </div>
                                        <?php
                                            $agree_policy = DB::table('basic_settings')->first();
                                        ?>

                                        <?php if($agree_policy->agree_policy == true): ?>
                                            <div class="col-lg-12 form-group">
                                                <div class="custom-check-group">
                                                    <input type="checkbox" id="level-1" name="agree">
                                                    <label for="level-1"
                                                        class="mb-0"><?php echo e(__('I have read agreed with the')); ?> <a
                                                            href="<?php echo e(url('useful-link/terms-condition')); ?>"
                                                            class="text--base"><?php echo e(__('Terms & Conditions')); ?></a></label>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col-lg-12 form-group text-center">
                                            <button type="submit"
                                                class="btn--base w-100"><?php echo e(__('Register Now')); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/user/auth/login-register.blade.php ENDPATH**/ ?>